
/*
vec3 GetWavesNormalForLight(vec3 position) {

	vec2 coord = position.xz;
	vec3 lightVector = refract(worldLightVector, vec3(0.0, 1.0, 0.0), 1.0 / WATER_REFRACT_IOR);
	coord.x += position.y * lightVector.x / lightVector.y;
	coord.y += position.y * lightVector.z / lightVector.y;

	coord *= 0.02;
	coord = mod(coord, vec2(1.0));

	vec3 normal = DecodeNormal(texture(colortex0, coord).xy);

	return normal;
}
*/

#include "/lib/Water/WaterWave.glsl"

vec2 CalculateRefractCoord(in TranslucentMask mask, in vec3 normal, in vec3 worldPos, in vec3 viewPos, in float depth, in float depthT) {
	if (!mask.translucent) return texcoord;

	vec2 refractCoord;
	float waterDepth = GetDepthLinear(depthT);
	float refractionDepth = GetDepthLinear(depth) - waterDepth;

	if (mask.water) {
		vec3 wavesNormal = GetWavesNormal(worldPos + cameraPosition).xzy;
		vec3 waterNormal = mat3(gbufferModelView) * wavesNormal;
		
		vec3 nv = normalize(gbufferModelView[1].xyz);

		refractCoord = nv.xy - normalize(waterNormal).xy;
		refractCoord *= saturate(refractionDepth) * 0.5 / (waterDepth + 1e-4);
		refractCoord += texcoord;
	} else {
		vec3 refractDir = refract(normalize(viewPos), normal, 1.0 / GLASS_REFRACT_IOR);
		refractDir /= saturate(dot(refractDir, -normal));
		refractDir *= saturate(refractionDepth * 2.0) * 0.125;

		refractCoord = ViewToScreenSpaceRaw(viewPos + refractDir).xy;
	}
	
	//float currentDepth = texture(depthtex0, texcoord).x;
	float refractDepth = texture(depthtex1, refractCoord).x;
	if (refractDepth < depthT) return texcoord;
		
	return saturate(refractCoord) == refractCoord ? refractCoord : texcoord;
}
